-- Warrior_Code.lua
-- Author: Machiavelli
-- DateCreated: 6/14/2012 11:50:07 AM
--------------------------------------------------------------
-- Gives the promotion to any newly produced Great Generals
function GivePromotionIfGreatGeneral(playerID, unitID, hexVec, unitType, cultureType, civID, primaryColor, secondaryColor, unitFlagIndex, fogState, selected, military, notInvisible)
	local player = Players[playerID];
	local unit = player:GetUnitByID(unitID);
	local policyID = GameInfoTypes["POLICY_WARRIOR_CODE"];
	local promotionID = GameInfo.UnitPromotions["PROMOTION_GREAT_GENERAL_HEAL"].ID;

	-- Only give the promotion if the player has the policy and the unit has the great general promotion
	if(player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID) and unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_GREAT_GENERAL"]) then
		unit:SetHasPromotion(promotionID, true);
	end
end
LuaEvents.SerialEventUnitCreatedGood.Add(GivePromotionIfGreatGeneral);

-- Gives the promotion to Great Generals that already exist
function GivePromotionToExistingGreatGenerals(playerID, policyTypeID)
	local player = Players[playerID];
	local policyID = GameInfoTypes["POLICY_WARRIOR_CODE"];
	local promotionID = GameInfo.UnitPromotions["PROMOTION_GREAT_GENERAL_HEAL"].ID;

	-- Only care if the policy just adopted was the one we care about
	if(policyTypeID == policyID) then
		-- Loop over all the units the player has
		for unit in player:Units() do
			if(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_GREAT_GENERAL"]) then
				unit:SetHasPromotion(promotionID, true);
			end
		end
	end
end
GameEvents.PlayerAdoptPolicy.Add(GivePromotionToExistingGreatGenerals);


